//----------------------------------------------------------------------------//
//- CadSchlussabrechnung.pas -------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// Stellt die Schlussabrechnung am Ende einer Brse dar.                      //
//----------------------------------------------------------------------------//

unit CadSchlussabrechnung;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, CadBaseDialog, StdCtrls, ExtCtrls, CaoBoersenInfo, CaoFormat,
  CaoArtikelListe;

//------------------------------------------------------------------------------

type
  TCaDlgSchlussabrechnung = class(TCaDlgBaseDialog)

    //--------------------------------------------------------------------------

    m_GrpBoersendaten               : TGroupBox;
    m_LblName                       : TLabel;
    m_LblDatumg                     : TLabel;
    m_GrpAbgaben                    : TGroupBox;
    m_LblAbgabenProzent             : TLabel;
    m_LblAnteilBetrag               : TLabel;
    m_GrpUebersicht                 : TGroupBox;
    m_LblUmsatz                     : TLabel;
    m_LblGewinn                     : TLabel;
    m_PanSeparator1                 : TPanel;
    m_LblAnzahlArtikel              : TLabel;
    m_LblAnzahlVerkauft             : TLabel;
    m_LblAnzahlNichtVerkauft        : TLabel;
    m_LblAnzName                    : TLabel;
    m_LblAnzAbgabenProzent          : TLabel;
    m_LblAnzUmsatz                  : TLabel;
    m_LblAnzGewinn                  : TLabel;
    m_LblAnzDatum                   : TLabel;
    m_LblAnzAnteilBetrag            : TLabel;
    m_LblAnzAgeboteneArtikel        : TLabel;
    m_LblAnzVerkaufteArtikel        : TLabel;
    m_LblAnzNichtVerkaufteArtikel   : TLabel;
    m_BtnDrucken                    : TButton;
    m_PanSeparator                  : TPanel;

    //--------------------------------------------------------------------------

    procedure FormShow(Sender: TObject);
    procedure BtnDruckenClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);

  //---------------------------------------------------------------------------- 

  public
    function ShowModal(obBoersenInfo : TCaoBoersenInfo;
                       obArtikelListe: TCaoArtikelListe): Integer; reintroduce;

  //----------------------------------------------------------------------------

  private
    m_obBoersenInfo  : TCaoBoersenInfo;
    m_obArtikelListe : TCaoArtikelListe;
    m_obFormat       : TCaoFormat;

    //--------------------------------------------------------------------------

    procedure PrvLoadData;

  //----------------------------------------------------------------------------

  end; // TCaDlgSchlussabrechnung

//------------------------------------------------------------------------------

var
  CaDlgSchlussabrechnung: TCaDlgSchlussabrechnung;

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

uses
  CaoController;

//------------------------------------------------------------------------------

{$R *.dfm}

//------------------------------------------------------------------------------

procedure TCaDlgSchlussabrechnung.PrvLoadData;
begin
  m_LblAnzName.Caption            := m_obBoersenInfo.sTitel;
  m_LblAnzDatum.Caption           := DateToStr(m_obBoersenInfo.dtBoersenDatum);
  m_LblAnzAbgabenProzent.Caption  := FloatToStr(m_obBoersenInfo.dAbgabeProzent);
  m_LblAnzAnteilBetrag.Caption    :=
                       m_obFormat.FormatCurrency(m_obBoersenInfo.dAbgabeBetrag);
  m_LblAnzUmsatz.Caption  := m_obFormat.FormatCurrency(m_obArtikelListe.GetGewinn);
  m_LblAnzGewinn.Caption  := m_obFormat.FormatCurrency
    (m_obArtikelListe.GetGewinnFromBetrag(m_obBoersenInfo.dAbgabeBetrag) +
     m_obArtikelListe.GetGewinnFromProzent(m_obBoersenInfo.dAbgabeProzent));
  m_LblAnzAgeboteneArtikel.Caption := IntToStr(m_obArtikelListe.Count);
  m_LblAnzVerkaufteArtikel.Caption := IntToStr(m_obArtikelListe.GetTotalVerkauft);
  m_LblAnzNichtVerkaufteArtikel.Caption :=
    IntToStr(m_obArtikelListe.GetTotalNichtVerkauft);
end; // TCaDlgSchlussabrechnung.PrvLoadData

//------------------------------------------------------------------------------

function TCaDlgSchlussabrechnung.ShowModal(obBoersenInfo: TCaoBoersenInfo;
                                           obArtikelListe: TCaoArtikelListe): Integer;
begin
  m_obBoersenInfo  := obBoersenInfo;
  m_obArtikelListe := obArtikelListe;
  Result           := inherited ShowModal;
end; // TCaDlgSchlussabrechnung.ShowModal

//------------------------------------------------------------------------------

procedure TCaDlgSchlussabrechnung.FormShow(Sender: TObject);
begin
  inherited;
  PrvLoadData;
end; // TCaDlgSchlussabrechnung.FormShow

//------------------------------------------------------------------------------

procedure TCaDlgSchlussabrechnung.BtnDruckenClick(Sender: TObject);
begin
  inherited;
  g_obController.PreviewAbschlussDaten;
end; // TCaDlgSchlussabrechnung.BtnDruckenClick

//------------------------------------------------------------------------------

procedure TCaDlgSchlussabrechnung.FormCreate(Sender: TObject);
begin
  inherited;
  m_obFormat := TCaoFormat.Create;
end; // TCaDlgSchlussabrechnung.FormCreate

//------------------------------------------------------------------------------

procedure TCaDlgSchlussabrechnung.FormDestroy(Sender: TObject);
begin
  m_obFormat.Free;
  inherited;
end; // TCaDlgSchlussabrechnung.FormDestroy

//------------------------------------------------------------------------------

end. // CadSchlussabrechnung
